#!/usr/bin/env bash
set -euo pipefail

# ===== DESTINO (cpanel) =====
HOST="zonda.whservers.net"
CP_USER="pruebawm"
CP_PASS="Z46174uruz"
DEST="public_html"                         # ruta relativa al home cPanel
SITE_URL="https://prueba-wm.wiz.com.ar"    # URL pública

# ===== ORIGEN =====
LOCAL_SRC="/home/tomaswiz/public_html"     # raíz del WP origen
ZIP_PATH="/tmp/wizmig_site.zip"

say(){ printf '\n\033[1;34m==> %s\033[0m\n' "$*"; }
ok(){  printf '\033[0;32m✔ %s\033[0m\n' "$*"; }
err(){ printf '\033[0;31m✖ %s\033[0m\n' "$*"; }

# 0) Normalizar DEST
DEST="${DEST#/}"
DEST="${DEST:-public_html}"

# 1) Pre-chequeo 2083
say "Chequeando 2083… (200/301/302/401/403 = OK)"
RC=$(curl -sk "https://${HOST}:2083/execute/Fileman/list_files" -o /dev/null -w '%{http_code}')
case "$RC" in
  200|301|302|401|403) ok "2083 OK ($RC)";;
  *) err "UAPI 2083 no accesible (HTTP $RC)"; exit 1;;
esac

# 2) Probar credenciales
say "Probar credenciales…"
curl -sS -u "${CP_USER}:${CP_PASS}" --data "path=/public_html" \
  "https://${HOST}:2083/execute/Fileman/list_files" > /dev/null
ok "Credenciales válidas."

# 3) Crear ZIP (excluye caches/backups/logs/git/node_modules/otros)
say "Comprimiendo ${LOCAL_SRC} → ${ZIP_PATH} (esto es lo que más acelera)…"
cd "$LOCAL_SRC"
# Usamos zip si está disponible (más común en orígenes); si no, salimos con mensaje claro.
if ! command -v zip >/dev/null 2>&1; then
  err "No está 'zip' en este sistema. Instalalo o avisame y te doy variante TAR+extractor."
  exit 1
fi
rm -f "$ZIP_PATH"
zip -r "$ZIP_PATH" . \
  -x "wp-content/cache/**" "cache/**" "backup-*/**" "*.log" \
     "node_modules/**" ".git/**" "*.zip" "*.tgz" "*.tar" "*.tar.gz" >/dev/null
ls -lh "$ZIP_PATH"

# 4) Subir ZIP (una sola request)
say "Subiendo ZIP a /${DEST}…"
curl -sS -f -u "${CP_USER}:${CP_PASS}" \
  -F "dir=/${DEST}" -F "overwrite=1" \
  -F "file-1=@${ZIP_PATH};type=application/zip;filename=wizmig_site.zip" \
  "https://${HOST}:2083/execute/Fileman/upload_files" > /dev/null
ok "ZIP subido."

# 5) Subir extract.php (ZipArchive) y ejecutarlo por web
say "Subiendo extract.php…"
read -r -d '' EXTRACT <<"PHP"
<?php
@set_time_limit(0);
@ini_set('memory_limit','1024M');
$zip = __DIR__ . '/wizmig_site.zip';
$dest = __DIR__;
header('Content-Type: text/plain; charset=utf-8');
if (!file_exists($zip)) { http_response_code(404); echo "zip not found\n"; exit; }
if (!class_exists('ZipArchive')) { http_response_code(500); echo "ZipArchive missing in PHP\n"; exit; }
$z = new ZipArchive();
if ($z->open($zip) !== TRUE) { http_response_code(500); echo "cannot open zip\n"; exit; }
if (!$z->extractTo($dest)) { http_response_code(500); echo "extract failed\n"; exit; }
$z->close();
@unlink($zip);
@unlink(__FILE__); // se auto-borra
echo "OK\n";
PHP

curl -sS -f -u "${CP_USER}:${CP_PASS}" \
  --data-urlencode "path=/${DEST}/extract.php" \
  --data-urlencode "content=${EXTRACT}" \
  "https://${HOST}:2083/execute/Fileman/save_file" > /dev/null
ok "extract.php subido."

say "Ejecutando extractor por HTTP…"
EX_STATUS=$(curl -sk "${SITE_URL%/}/extract.php" -w ' HTTP:%{http_code}\n' -o /tmp/wizmig_extract.out || true)
echo "Extractor dijo:"
cat /tmp/wizmig_extract.out
echo "$EX_STATUS" | sed 's/^/ /'
ok "Extracción completada (si ves OK)."

# 6) (Opcional) borrar extract.php si quedó
curl -sS -u "${CP_USER}:${CP_PASS}" \
  --data "path=/${DEST}/extract.php" \
  "https://${HOST}:2083/execute/Fileman/delete" >/dev/null || true

ok "Listo. Sitio desplegado en ${SITE_URL}"

