<?php
if (!defined('ABSPATH')) exit;

class WizMig_Packager {
  private $destTop;
  public function __construct($destTop = 'public_html') {
    $this->destTop = ltrim($destTop, '/'); if (!$this->destTop) $this->destTop = 'public_html';
  }
  public function zip_site() {
    $upload_dir = wp_upload_dir();
    $work = trailingslashit($upload_dir['basedir']) . 'wizhosting-migrator';
    if (!wp_mkdir_p($work)) throw new Exception('Cannot create work dir: '.$work);
    $zipPath = trailingslashit($work) . 'wiz_files.zip'; if (file_exists($zipPath)) @unlink($zipPath);

    $root = ABSPATH;
    $zip = new ZipArchive(); if ($zip->open($zipPath, ZipArchive::CREATE)!==true) throw new Exception('Cannot open zip');
    $excludes = ['wp-content/cache/','cache/','.git/','node_modules/','*.zip','*.tar','*.tar.gz','*.tgz','*.log'];
    $it = new RecursiveIteratorIterator(new RecursiveDirectoryIterator($root, FilesystemIterator::SKIP_DOTS), RecursiveIteratorIterator::SELF_FIRST);
    foreach ($it as $file) {
      $abs = $file->getPathname();
      $rel = ltrim(str_replace('\\','/', substr($abs, strlen($root))), '/');
      $skip=false;
      foreach ($excludes as $ex) {
        if (fnmatch($ex, $rel)) { $skip=true; break; }
        if (substr($ex,-1)=='/' && stripos($rel, rtrim($ex,'/').'/')===0) { $skip=true; break; }
      }
      if ($skip) continue;
      $entry = $this->destTop . '/' . $rel;
      if ($file->isDir()) $zip->addEmptyDir($entry); else $zip->addFile($abs, $entry);
    }
    $zip->close();
    return $zipPath;
  }
}
