(function($){
  function log(msg){ $('#log').append((msg||'')+"\n").scrollTop(999999); }
  function vals(){
    return { action:'wizmig_start', nonce:WIZMIG.nonce,
      host: $('#host').val().trim(),
      cpuser: $('#cpuser').val().trim(),
      cppass: $('#cppass').val(),
      destdir: $('#destdir').val().trim(),
      domain_change: $('#domain_change').val(),
      destdomain: $('#destdomain').val().trim()
    };
  }
  $('#btnTest').on('click', function(e){
    e.preventDefault(); log('> '+WIZMIG.i18n.testing);
    $.post(WIZMIG.ajax, {
      action:'wizmig_test', nonce:WIZMIG.nonce,
      host:$('#host').val().trim(),
      cpuser:$('#cpuser').val().trim(),
      cppass:$('#cppass').val(), destdir:$('#destdir').val().trim()
    }).done(function(r){
      if(r.success){ log('✔ '+WIZMIG.i18n.ok); }
      else { log('✖ '+WIZMIG.i18n.error+': '+(r.data&&r.data.msg?r.data.msg:'')); }
    }).fail(function(){ log('✖ '+WIZMIG.i18n.error); });
  });
  $('#btnStart').on('click', function(e){
    e.preventDefault(); const data=vals();
    if(!data.host||!data.cpuser||!data.cppass){ log('✖ Completa host/usuario/clave. / Fill host/user/pass.'); return; }
    log('> '+WIZMIG.i18n.start);
    $.ajax({url:WIZMIG.ajax, method:'POST', data, timeout:0}).done(function(r){
      if(r.success){ log('✔ '+WIZMIG.i18n.done); if(r.data&&r.data.db){ log('DB: '+r.data.db.name+' / '+r.data.db.user); } }
      else { log('✖ '+WIZMIG.i18n.error+': '+(r.data&&r.data.msg?r.data.msg:'')); }
    }).fail(function(_,__,err){ log('✖ '+WIZMIG.i18n.error+': '+err); });
  });
})(jQuery);
