<?php
if (!defined('ABSPATH')) exit;

class WizMig_Admin {
  public function __construct() {
    add_action('admin_menu', [$this, 'menu']);
    add_action('admin_enqueue_scripts', [$this, 'assets']);
    add_action('wp_ajax_wizmig_test', [$this, 'ajax_test']);
    add_action('wp_ajax_wizmig_start', [$this, 'ajax_start']);
  }
  public function menu() {
    add_management_page(
      __('WizHosting Migrator', 'wizhosting-migrator'),
      __('WizHosting Migrator', 'wizhosting-migrator'),
      'manage_options',
      'wizhosting-migrator',
      [$this, 'page']
    );
  }
  public function assets($hook) {
    if ($hook !== 'tools_page_wizhosting-migrator') return;
    wp_enqueue_style('wizmig-admin', WIZMIG_URL.'assets/admin.css', [], WIZMIG_VER);
    wp_enqueue_script('wizmig-admin', WIZMIG_URL.'assets/admin.js', ['jquery'], WIZMIG_VER, true);
    wp_localize_script('wizmig-admin', 'WIZMIG', [
      'ajax' => admin_url('admin-ajax.php'),
      'nonce'=> wp_create_nonce('wizmig'),
      'i18n' => [
        'testing'  => __('Probando conexión… / Testing connection…','wizhosting-migrator'),
        'ok'       => __('OK','wizhosting-migrator'),
        'start'    => __('Iniciando migración… / Starting migration…','wizhosting-migrator'),
        'packing'  => __('Empaquetando archivos… / Packaging files…','wizhosting-migrator'),
        'restoreF' => __('Restaurando archivos en destino… / Restoring files on destination…','wizhosting-migrator'),
        'dbExport' => __('Exportando base de datos… / Exporting database…','wizhosting-migrator'),
        'dbCreate' => __('Creando DB/usuario en destino… / Creating DB/user on destination…','wizhosting-migrator'),
        'dbImport' => __('Restaurando base de datos… / Restoring database…','wizhosting-migrator'),
        'done'     => __('¡Listo! / Done!','wizhosting-migrator'),
        'error'    => __('Error','wizhosting-migrator'),
      ],
      'logo' => 'https://mi.wizhosting.com/wh_art/nuevas/option-03-color-with-bg-transparent-black-text-large.png',
    ]);
  }
  public function page() { ?>
    <div class="wrap wizmig-wrap">
      <div class="wizmig-card">
        <div class="wizmig-header">
          <img src="<?php echo esc_url('https://mi.wizhosting.com/wh_art/nuevas/option-03-color-with-bg-transparent-black-text-large.png'); ?>" alt="WizHosting" class="wizmig-logo" />
          <h1>WizHosting Migrator</h1>
          <p><?php esc_html_e('Migra tu sitio a WizHosting (cPanel) con un clic. / Migrate your site to WizHosting (cPanel) in one click.','wizhosting-migrator');?></p>
        </div>
        <div class="wizmig-body">
          <div class="wizmig-grid">
            <label><?php _e('Servidor / Hostname or IP','wizhosting-migrator');?></label>
            <input type="text" id="host" placeholder="zonda.whservers.net">
            <label><?php _e('Usuario cPanel / cPanel user','wizhosting-migrator');?></label>
            <input type="text" id="cpuser" placeholder="usuario">
            <label><?php _e('Clave cPanel / cPanel password','wizhosting-migrator');?></label>
            <input type="password" id="cppass" placeholder="••••••••">
            <label><?php _e('Carpeta destino (relative) / Destination folder','wizhosting-migrator');?></label>
            <input type="text" id="destdir" placeholder="public_html" value="public_html">
            <label><?php _e('Dominio en destino / Destination domain','wizhosting-migrator');?></label>
            <input type="text" id="destdomain" placeholder="(igual al actual / same as current)">
            <label><?php _e('¿El dominio cambia? / Domain changes?','wizhosting-migrator');?></label>
            <select id="domain_change">
              <option value="no"><?php _e('No (igual)','wizhosting-migrator');?></option>
              <option value="yes"><?php _e('Sí / Yes','wizhosting-migrator');?></option>
            </select>
            <div class="row">
              <button class="button button-secondary" id="btnTest"><?php _e('Probar conexión / Test connection','wizhosting-migrator');?></button>
              <button class="button button-primary" id="btnStart"><?php _e('Iniciar migración / Start migration','wizhosting-migrator');?></button>
            </div>
          </div>
          <pre class="wizmig-log" id="log"></pre>
        </div>
      </div>
    </div>
  <?php }
  private function need($key) {
    if (!isset($_POST[$key])) throw new Exception('Missing '.$key);
    return sanitize_text_field(wp_unslash($_POST[$key]));
  }
  public function ajax_test() {
    check_ajax_referer('wizmig','nonce');
    try {
      $host   = $this->need('host');
      $cpuser = $this->need('cpuser');
      $cppass = $this->need('cppass');
      $dest   = ltrim($this->need('destdir'), '/'); // relative to home
      $cp = new WizMig_CPanel($host, $cpuser, $cppass);
      $ok = $cp->uapi('Fileman', 'list_files', ['path' => '/'.$dest]);
      if (empty($ok['status'])) wp_send_json_error(['msg' => 'UAPI list_files failed','raw'=>$ok], 200);
      wp_send_json_success(['msg'=>'OK','raw'=>$ok],200);
    } catch (Throwable $e) { wp_send_json_error(['msg'=>$e->getMessage()], 200); }
  }
public function ajax_start() {
  check_ajax_referer('wizmig','nonce');
  @set_time_limit(0); @ini_set('memory_limit','1024M');

  try {
    global $wpdb;
    $host   = $this->need('host');
    $cpuser = $this->need('cpuser');
    $cppass = $this->need('cppass');
    $dest   = ltrim($this->need('destdir'), '/');
    $domain_change = $this->need('domain_change') === 'yes';
    $destdomain    = sanitize_text_field($_POST['destdomain'] ?? '');

    $cp = new WizMig_CPanel($host, $cpuser, $cppass);

    // 1) ZIP de archivos (sin carpeta toplevel)
    $pack = new WizMig_Packager();
    $zipPath = $pack->zip_site();
    $zipName = basename($zipPath);

    // 2) Subir ZIP a /$dest
    $up = $cp->uapi_multipart('/execute/Fileman/upload_files', [
      'dir'     => '/'.$dest,
      'file-1'  => new CURLFile($zipPath, 'application/zip', $zipName),
      'overwrite-dirs' => '1',
    ]);
    if (empty($up['status'])) throw new Exception('upload_files failed: '. json_encode($up));

    // 3) Extraer con API2 fileop=extract
    $ex = $cp->api2('Fileman','fileop', [
      'op'          => 'extract',
      'sourcefiles' => '/'.$dest.'/'.$zipName,
      'doubledecode'=> 1
      // 'destfiles' => '/'.$dest'  // no imprescindible; extrae al mismo directorio del zip
    ]);
    if (empty($ex['cpanelresult']['event']['result'])) {
      throw new Exception('extract failed: '. json_encode($ex));
    }

    // 4) DB: crear en destino y restaurar
    $prefix = $cpuser . '_';
    $dstName = preg_replace('~[^A-Za-z0-9_]~','', DB_NAME);
    $dstUser = preg_replace('~[^A-Za-z0-9_]~','', DB_USER);
    if (strpos($dstName, $prefix) !== 0) $dstName = $prefix.$dstName;
    if (strpos($dstUser, $prefix) !== 0) $dstUser = $prefix.$dstUser;
    $dstPass = wp_generate_password(20, true, true);

    $cp->uapi('Mysql','create_database', ['name'=>$dstName]);
    $cp->uapi('Mysql','create_user',     ['name'=>$dstUser, 'password'=>$dstPass]);
    $cp->uapi('Mysql','set_privileges_on_database', [
      'user'=>$dstUser,'database'=>$dstName,'privileges'=>'ALL PRIVILEGES'
    ]);

    $fromDomain = home_url();
    $toDomain   = ($domain_change && $destdomain) ? $destdomain : $fromDomain;
    $dump = new WizMig_DBDump($wpdb, $fromDomain, $toDomain);
    $sqlGz = $dump->export_gz();

    // 5) Restaurar DB via UAPI Backup::restore_databases (éste sí acepta .sql.gz)
    $rd = $cp->uapi_multipart('/execute/Backup/restore_databases', [
      'file'    => new CURLFile($sqlGz, 'application/gzip', basename($sqlGz)),
      'timeout' => '0', 'verbose' => '1',
    ]);
    if (empty($rd['status'])) throw new Exception('restore_databases failed: '. json_encode($rd));

    // 6) Escribir wp-config.php en el destino (ruta corregida)
    $wpconfig = "<?php\n";
    $wpconfig.= "define('DB_NAME','{$dstName}');\n";
    $wpconfig.= "define('DB_USER','{$dstUser}');\n";
    $wpconfig.= "define('DB_PASSWORD','{$dstPass}');\n";
    $wpconfig.= "define('DB_HOST','localhost');\n";
    $wpconfig.= "define('DB_CHARSET','utf8mb4');\n";
    $wpconfig.= "define('DB_COLLATE','');\n";
    $wpconfig.= "require_once __DIR__ . '/wp-settings.php';\n";

    $sf = $cp->uapi('Fileman','save_file',[
      'path'=> '/'.$dest.'/wp-config.php',
      'content'=> $wpconfig,
    ]);

    @unlink($zipPath); @unlink($sqlGz);

    wp_send_json_success([
      'msg'=>'Migration finished',
      'db'=>['name'=>$dstName,'user'=>$dstUser],
      'upload'=>$up ?? null,
      'extract'=>$ex ?? null,
      'db_log'=>$rd['data'] ?? null,
      'wpconfig_saved'=>$sf['status'] ?? null
    ],200);

  } catch (Throwable $e) {
    wp_send_json_error(['msg'=>$e->getMessage()], 200);
  }
}

