<?php
if (!defined('ABSPATH')) exit;

class WizMig_Packager {
  public function __construct($unused = null) {}

  public function zip_site() {
    $upload_dir = wp_upload_dir();
    $work = trailingslashit($upload_dir['basedir']) . 'wizhosting-migrator';
    if (!wp_mkdir_p($work)) throw new Exception('Cannot create work dir: '.$work);
    $zipPath = trailingslashit($work) . 'wiz_files.zip';
    if (file_exists($zipPath)) @unlink($zipPath);

    $root = ABSPATH; // incluir todo el WP origen
    $zip = new ZipArchive();
    if ($zip->open($zipPath, ZipArchive::CREATE)!==true) throw new Exception('Cannot open zip');

    $excludes = ['wp-content/cache/','cache/','.git/','node_modules/','*.zip','*.tar','*.tar.gz','*.tgz','*.log'];
    $it = new RecursiveIteratorIterator(new RecursiveDirectoryIterator($root, FilesystemIterator::SKIP_DOTS), RecursiveIteratorIterator::SELF_FIRST);

    foreach ($it as $file) {
      $abs = $file->getPathname();
      $rel = ltrim(str_replace('\\','/', substr($abs, strlen($root))), '/');
      $skip=false;
      foreach ($excludes as $ex) {
        if (fnmatch($ex, $rel)) { $skip=true; break; }
        if (substr($ex,-1)=='/' && stripos($rel, rtrim($ex,'/').'/')===0) { $skip=true; break; }
      }
      if ($skip) continue;

      // SIN carpeta toplevel: que el ZIP tenga rutas "wp-admin/...", "wp-content/...", etc.
      if ($file->isDir()) $zip->addEmptyDir($rel); else $zip->addFile($abs, $rel);
    }
    $zip->close();
    return $zipPath;
  }
}

